#include <bits/stdc++.h>

using namespace std;

void Backtrack(int pos, vector<bool> &res, vector<pair<int, int>> pom, double &d, vector<int> &r)
{
    if(pos == res.size())
    {
        int x = 0, y = 0;
        for(int i = 0; i < pos; i++)
        {
            if(res[i])
            {
                x += pom[i].first;
                y += pom[i].second;
            }
        }
        double temp = sqrt((x*x + y*y) * 1.0);
        if(temp > d)
        {
            d = temp;
            for(int i = 0; i < pos; i++)
            {
                if(res[i])
                    r[i] = 1;
                else
                    r[i] = 0;
            }
        }
        return;
    }

    res[pos] = false;
    Backtrack(pos + 1, res, pom, d, r);
    res[pos] = true;
    Backtrack(pos + 1, res, pom, d, r);
}

int main()
{
    int n, x, y;
    cin >> n;
    vector<pair<int, int>> pom(n, make_pair(0, 0));
    for(int i = 0; i < n; i++)
    {
        cin >> x >> y;
        pom[i] = make_pair(x, y);
    }

    double d = 0;
    vector<int> r(n, 0);
    vector<bool> res(n, false);
    Backtrack(0, res, pom, d, r);
    x = accumulate(r.begin(), r.end(), 0);
    cout << x << "\n";
    for(int i = 0; i < n; i++)
        if(r[i] == 1)
            cout << i + 1 << " ";
    return 0;
}